<?php
require_once 'database.php';

// Configuración de sesiones
ini_set('session.cookie_lifetime', 7200); // 2 horas
ini_set('session.gc_maxlifetime', 7200); // 2 horas
session_start();

// Función para verificar si el usuario está autenticado
function verificarAutenticacion() {
    if (!isset($_SESSION['usuario_id']) || !isset($_SESSION['login_time'])) {
        return false;
    }
    
    // Verificar si la sesión ha expirado (2 horas)
    $tiempo_actual = time();
    $tiempo_login = $_SESSION['login_time'];
    $tiempo_expiracion = 7200; // 2 horas en segundos
    
    if (($tiempo_actual - $tiempo_login) > $tiempo_expiracion) {
        cerrarSesion();
        return false;
    }
    
    return true;
}

// Función para autenticar usuario
function autenticarUsuario($correo, $password) {
    try {
        $pdo = conectarDB();
        
        // Buscar usuario por correo y user_login (password)
        $stmt = $pdo->prepare("SELECT ID, user_email, user_login FROM wpnc_users WHERE user_email = ? AND user_login = ?");
        $stmt->execute([$correo, $password]);
        $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($usuario) {
            // Iniciar sesión
            $_SESSION['usuario_id'] = $usuario['ID'];
            $_SESSION['user_email'] = $usuario['user_email'];
            $_SESSION['user_login'] = $usuario['user_login'];
            $_SESSION['login_time'] = time();
            
            return true;
        }
        
        return false;
    } catch (PDOException $e) {
        error_log("Error en autenticación: " . $e->getMessage());
        return false;
    }
}

// Función para cerrar sesión
function cerrarSesion() {
    // Destruir todas las variables de sesión
    $_SESSION = array();
    
    // Destruir la cookie de sesión
    if (ini_get("session.use_cookies")) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000,
            $params["path"], $params["domain"],
            $params["secure"], $params["httponly"]
        );
    }
    
    // Destruir la sesión
    session_destroy();
}

// Función para redirigir a login si no está autenticado
function requerirAutenticacion() {
    if (!verificarAutenticacion()) {
        header('Location: login.php');
        exit();
    }
}

// Función para obtener información del usuario actual
function obtenerUsuarioActual() {
    if (verificarAutenticacion()) {
        return [
            'id' => $_SESSION['usuario_id'],
            'email' => $_SESSION['user_email'],
            'login' => $_SESSION['user_login']
        ];
    }
    return null;
}
?>
