<?php
// Generador de thumbnails simplificado que funciona en más entornos
require_once 'file_upload.php';

// Función simplificada para generar thumbnails
function generarThumbnailSimple($rutaPDF, $nombreArchivo) {
    crearDirectorios();
    
    $nombreThumbnail = pathinfo($nombreArchivo, PATHINFO_FILENAME) . '_thumb.jpg';
    $rutaThumbnail = THUMBNAIL_DIR . $nombreThumbnail;
    
    // Intentar con ImageMagick primero
    if (extension_loaded('imagick') && class_exists('Imagick')) {
        try {
            $imagick = new Imagick();
            $imagick->setResolution(150, 150);
            $imagick->readImage($rutaPDF . '[0]');
            $imagick->setImageFormat('jpeg');
            $imagick->setImageCompressionQuality(85);
            $imagick->thumbnailImage(200, 200, true, true);
            $imagick->writeImage($rutaThumbnail);
            $imagick->clear();
            $imagick->destroy();
            
            if (file_exists($rutaThumbnail)) {
                return $nombreThumbnail;
            }
        } catch (Exception $e) {
            error_log("Error con ImageMagick: " . $e->getMessage());
        }
    }
    
    // Si ImageMagick falla, crear un placeholder mejorado
    if (extension_loaded('gd')) {
        $imagen = imagecreatetruecolor(200, 200);
        
        // Colores
        $fondo = imagecolorallocate($imagen, 245, 245, 245);
        $borde = imagecolorallocate($imagen, 200, 200, 200);
        $texto = imagecolorallocate($imagen, 100, 100, 100);
        $titulo = imagecolorallocate($imagen, 50, 50, 50);
        $accent = imagecolorallocate($imagen, 59, 130, 246); // Azul
        
        // Fondo
        imagefill($imagen, 0, 0, $fondo);
        
        // Borde
        imagerectangle($imagen, 0, 0, 199, 199, $borde);
        
        // Icono de PDF (rectángulo con esquina doblada)
        $pdfIcon = imagecolorallocate($imagen, 220, 38, 38); // Rojo
        imagefilledrectangle($imagen, 60, 50, 140, 120, $pdfIcon);
        imagefilledrectangle($imagen, 120, 50, 140, 70, $fondo);
        
        // Texto "PDF"
        imagestring($imagen, 4, 80, 90, 'PDF', imagecolorallocate($imagen, 255, 255, 255));
        
        // Nombre del archivo (truncado)
        $nombreCorto = substr(pathinfo($nombreArchivo, PATHINFO_FILENAME), 0, 12);
        if (strlen($nombreCorto) < strlen(pathinfo($nombreArchivo, PATHINFO_FILENAME))) {
            $nombreCorto .= '...';
        }
        imagestring($imagen, 2, 10, 130, $nombreCorto, $titulo);
        
        // Tamaño del archivo
        if (file_exists($rutaPDF)) {
            $tamaño = filesize($rutaPDF);
            $tamañoTexto = formatBytes($tamaño);
            imagestring($imagen, 2, 10, 150, $tamañoTexto, $texto);
        }
        
        // Fecha
        imagestring($imagen, 2, 10, 170, date('d/m/Y'), $texto);
        
        imagejpeg($imagen, $rutaThumbnail, 85);
        imagedestroy($imagen);
        
        return $nombreThumbnail;
    }
    
    return null;
}

// Función para regenerar thumbnails existentes
function regenerarThumbnails() {
    require_once 'database.php';
    
    $pdo = conectarDB();
    $stmt = $pdo->query("SELECT id, url_documento FROM repositorio WHERE url_documento IS NOT NULL");
    $repositorios = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $regenerados = 0;
    $errores = 0;
    
    foreach ($repositorios as $repo) {
        $rutaPDF = UPLOAD_DIR . $repo['url_documento'];
        
        if (file_exists($rutaPDF)) {
            $thumbnail = generarThumbnailSimple($rutaPDF, $repo['url_documento']);
            
            if ($thumbnail) {
                // Actualizar en la base de datos
                $stmt = $pdo->prepare("UPDATE repositorio SET thumbnails = ? WHERE id = ?");
                $stmt->execute([$thumbnail, $repo['id']]);
                $regenerados++;
            } else {
                $errores++;
            }
        }
    }
    
    return ['regenerados' => $regenerados, 'errores' => $errores];
}
?>
