<?php
require_once 'config/auth.php';
require_once 'config/file_upload.php';

// Verificar autenticación
requerirAutenticacion();

$mensaje = '';
$error = '';

// Procesar regeneración de thumbnails
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['regenerar'])) {
    $pdo = conectarDB();
    $stmt = $pdo->query("SELECT id, url_documento FROM repositorio WHERE url_documento IS NOT NULL");
    $repositorios = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    $regenerados = 0;
    $errores = 0;
    
    foreach ($repositorios as $repo) {
        $rutaPDF = UPLOAD_DIR . $repo['url_documento'];
        
        if (file_exists($rutaPDF)) {
            $thumbnail = generarThumbnailPDF($rutaPDF, $repo['url_documento']);
            
            if ($thumbnail) {
                // Actualizar en la base de datos
                $stmt = $pdo->prepare("UPDATE repositorio SET thumbnails = ? WHERE id = ?");
                $stmt->execute([$thumbnail, $repo['id']]);
                $regenerados++;
            } else {
                $errores++;
            }
        }
    }
    
    if ($regenerados > 0) {
        $mensaje = "Se regeneraron {$regenerados} thumbnails exitosamente.";
        if ($errores > 0) {
            $mensaje .= " {$errores} archivos tuvieron errores.";
        }
    } else {
        $error = "No se pudieron regenerar los thumbnails. Verifique que ImageMagick o GD estén instalados.";
    }
}

// Obtener estadísticas
$pdo = conectarDB();
$stmt = $pdo->query("SELECT COUNT(*) as total FROM repositorio WHERE url_documento IS NOT NULL");
$totalRepos = $stmt->fetch(PDO::FETCH_ASSOC)['total'];

$stmt = $pdo->query("SELECT COUNT(*) as total FROM repositorio WHERE thumbnails IS NOT NULL");
$totalThumbnails = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Regenerar Thumbnails</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 min-h-screen">
    <!-- Header con información del usuario -->
    <div class="bg-white shadow-sm border-b">
        <div class="container mx-auto px-4 py-4">
            <div class="flex justify-between items-center">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Regenerar Thumbnails</h1>
                    <p class="text-sm text-gray-600">
                        Usuario: <?php echo htmlspecialchars(obtenerUsuarioActual()['email']); ?>
                    </p>
                </div>
                <div class="flex items-center space-x-4">
                    <a href="gestion_repositorios.php" 
                       class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md text-sm transition duration-200">
                        ← Volver a Gestión
                    </a>
                    <a href="logout.php" 
                       class="bg-red-500 hover:bg-red-600 text-white px-4 py-2 rounded-md text-sm transition duration-200">
                        Cerrar Sesión
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="container mx-auto px-4 py-8">
        <!-- Mensajes -->
        <?php if ($mensaje): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4">
                <?php echo htmlspecialchars($mensaje); ?>
            </div>
        <?php endif; ?>
        
        <?php if ($error): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                <?php echo htmlspecialchars($error); ?>
            </div>
        <?php endif; ?>
        
        <!-- Información del sistema -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-8">
            <h2 class="text-xl font-semibold mb-4">Estado del Sistema</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                <div class="bg-blue-50 p-4 rounded-lg">
                    <h3 class="font-semibold text-blue-800">Total Repositorios</h3>
                    <p class="text-2xl font-bold text-blue-600"><?php echo $totalRepos; ?></p>
                </div>
                
                <div class="bg-green-50 p-4 rounded-lg">
                    <h3 class="font-semibold text-green-800">Thumbnails Generados</h3>
                    <p class="text-2xl font-bold text-green-600"><?php echo $totalThumbnails; ?></p>
                </div>
                
                <div class="bg-yellow-50 p-4 rounded-lg">
                    <h3 class="font-semibold text-yellow-800">Sin Thumbnails</h3>
                    <p class="text-2xl font-bold text-yellow-600"><?php echo $totalRepos - $totalThumbnails; ?></p>
                </div>
            </div>
            
            <!-- Información de extensiones -->
            <div class="mb-6">
                <h3 class="font-semibold mb-2">Extensiones PHP Disponibles:</h3>
                <div class="flex gap-4">
                    <span class="px-3 py-1 rounded-full text-sm <?php echo extension_loaded('imagick') && class_exists('Imagick') ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                        ImageMagick: <?php echo extension_loaded('imagick') && class_exists('Imagick') ? '✅' : '❌'; ?>
                    </span>
                    <span class="px-3 py-1 rounded-full text-sm <?php echo extension_loaded('gd') ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                        GD: <?php echo extension_loaded('gd') ? '✅' : '❌'; ?>
                    </span>
                </div>
            </div>
            
            <!-- Formulario de regeneración -->
            <form method="POST" onsubmit="return confirm('¿Está seguro de regenerar todos los thumbnails? Esto puede tomar varios minutos.')">
                <button type="submit" name="regenerar" 
                        class="bg-blue-500 hover:bg-blue-600 text-white px-6 py-2 rounded-md transition duration-200">
                    Regenerar Todos los Thumbnails
                </button>
            </form>
        </div>
        
        <!-- Instrucciones -->
        <div class="bg-white rounded-lg shadow-md p-6">
            <h2 class="text-xl font-semibold mb-4">Instrucciones para Mejorar la Generación de Thumbnails</h2>
            
            <div class="space-y-4">
                <div>
                    <h3 class="font-semibold text-gray-800">Para obtener thumbnails reales de PDF:</h3>
                    <ul class="list-disc list-inside text-gray-600 space-y-1">
                        <li><strong>Ubuntu/Debian:</strong> <code>sudo apt-get install php-imagick ghostscript</code></li>
                        <li><strong>CentOS/RHEL:</strong> <code>sudo yum install php-imagick ghostscript</code></li>
                        <li><strong>Windows:</strong> Descargar ImageMagick desde <a href="https://imagemagick.org/script/download.php#windows" class="text-blue-600 hover:underline" target="_blank">imagemagick.org</a></li>
                    </ul>
                </div>
                
                <div>
                    <h3 class="font-semibold text-gray-800">Alternativas:</h3>
                    <ul class="list-disc list-inside text-gray-600 space-y-1">
                        <li><strong>poppler-utils:</strong> <code>sudo apt-get install poppler-utils</code> (para pdftoppm)</li>
                        <li><strong>wkhtmltopdf:</strong> Para crear PDFs de prueba</li>
                    </ul>
                </div>
                
                <div class="bg-yellow-50 p-4 rounded-lg">
                    <p class="text-yellow-800">
                        <strong>Nota:</strong> Si no tienes ImageMagick instalado, el sistema creará thumbnails placeholder con información del archivo PDF.
                    </p>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
